#include "stdafx.h"
#include "CLS_NetAdmin_Interface.h"

HINSTANCE CLS_NetAdmin_Interface::s_hInstance  = NULL;
CString CLS_NetAdmin_Interface::s_strFilePath = _T("");

extern CString g_strInstDir;

IMPLEMENT_FUNCTION(NetAdmin_Startup);
IMPLEMENT_FUNCTION(NetAdmin_Closeup);
IMPLEMENT_FUNCTION(NetAdmin_SetNotify);
IMPLEMENT_FUNCTION(NetAdmin_SeekServers);
IMPLEMENT_FUNCTION(NetAdmin_ChangeIP);
IMPLEMENT_FUNCTION(NetAdmin_RebootServer);
IMPLEMENT_FUNCTION(NetAdmin_ChangeMAC);
IMPLEMENT_FUNCTION(NetAdmin_ChangePort);
IMPLEMENT_FUNCTION(NetAdmin_SetNetInterface);
IMPLEMENT_FUNCTION(NetAdmin_GetNetInterface);

bool CLS_NetAdmin_Interface::LoadDLL()
{
	if(s_strFilePath.Compare(_T("")) == 0)
	{
		s_strFilePath =g_strInstDir + _T("NetAdmin.dll");
	}

	if (s_hInstance)
	{
		return true;
	}

    s_hInstance = LoadLibrary(s_strFilePath.Trim());
    if(!s_hInstance) 
		return false;

	EXPORT_FUNCTION(s_hInstance,NetAdmin_Startup);
	EXPORT_FUNCTION(s_hInstance,NetAdmin_Closeup);
	EXPORT_FUNCTION(s_hInstance,NetAdmin_SetNotify);
	EXPORT_FUNCTION(s_hInstance,NetAdmin_SeekServers);
	EXPORT_FUNCTION(s_hInstance,NetAdmin_ChangeIP);
	EXPORT_FUNCTION(s_hInstance,NetAdmin_RebootServer);
	EXPORT_FUNCTION(s_hInstance,NetAdmin_ChangeMAC);
	EXPORT_FUNCTION(s_hInstance,NetAdmin_ChangePort);
	EXPORT_FUNCTION(s_hInstance, NetAdmin_SetNetInterface);
	EXPORT_FUNCTION(s_hInstance, NetAdmin_GetNetInterface);

    return true;
}

void CLS_NetAdmin_Interface::FreeDLL()
{
    if(s_hInstance)
    {
        ::FreeLibrary(s_hInstance);
        s_hInstance = NULL;
    }
}
